/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr;

import f00f.net.irc.martyr.Debug;
import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.InCommand;
import java.util.Observable;
import java.util.Observer;

public class ClientStateMonitor
implements Observer {
    private IRCConnection connection;
    private boolean enabled = false;

    ClientStateMonitor(IRCConnection connection) {
        this.connection = connection;
        this.enable();
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.connection.addCommandObserver(this);
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.connection.removeCommandObserver(this);
        this.enabled = false;
    }

    public void update(Observable observable, Object command_o) {
        InCommand command = (InCommand)command_o;
        try {
            if (command.updateClientState(this.connection.getClientState())) {
                Debug.println("ClientStateMonitor", "Client state updated", 10);
            }
        }
        catch (Throwable e) {
            Debug.println("ClientStateMonitor", "Client state update failed.", 5);
            Debug.println("ClientStateMonitor", e.toString(), 5);
            e.printStackTrace();
        }
    }
}

