/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr;

import f00f.net.irc.martyr.ClientStateMonitor;
import f00f.net.irc.martyr.Command;
import f00f.net.irc.martyr.CommandObserver;
import f00f.net.irc.martyr.CommandRegister;
import f00f.net.irc.martyr.CommandSender;
import f00f.net.irc.martyr.CronManager;
import f00f.net.irc.martyr.Debug;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.InputHandler;
import f00f.net.irc.martyr.OutCommand;
import f00f.net.irc.martyr.State;
import f00f.net.irc.martyr.StateObserver;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.UnknownCommand;
import f00f.net.irc.martyr.errors.UnknownError;
import f00f.net.irc.martyr.replies.UnknownReply;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Observer;
import java.util.StringTokenizer;

public class IRCConnection {
    private CommandSender commandSender;
    private CronManager cronManager;
    private State state;
    private ClientState clientState;
    private StateObserver stateObservers;
    private CommandObserver commandObservers;
    private Socket socket;
    private Object connectMonitor = new Object();
    private Object eventMonitor = new Object();
    private boolean disconnectPending = false;
    private BufferedWriter socketWriter;
    private BufferedReader socketReader;
    private CommandRegister commandRegister;
    private InputHandler inputHandler;
    private Object inputHandlerMonitor = new Object();
    private LinkedList stateQueue;
    private LinkedList localEventQueue;
    private boolean settingState = false;
    private EventThread eventThread;
    private int sendDelay = 300;
    private boolean connected = false;
    private boolean daemon = false;

    public IRCConnection() {
        this(new ClientState());
    }

    public IRCConnection(ClientState clientState) {
        this.stateObservers = new StateObserver();
        this.commandObservers = new CommandObserver();
        this.clientState = clientState;
        this.stateQueue = new LinkedList();
        this.commandRegister = new CommandRegister();
        this.commandSender = new DefaultCommandSender();
        this.setState(State.UNCONNECTED);
        new ClientStateMonitor(this);
        this.localEventQueue = new LinkedList();
        this.eventThread = new EventThread();
        this.eventThread.setDaemon(true);
        this.startEventThread();
    }

    protected void startEventThread() {
        this.eventThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String server, int port) throws UnknownHostException, IOException {
        Object object = this.connectMonitor;
        synchronized (object) {
            Debug.println(this, "Connecting to " + server + ":" + port, 15);
            if (this.connected) {
                Debug.println(this, "Connect requested, but we are already connected!", 5);
                return;
            }
            this.connectUnsafe(new Socket(server, port), server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Socket customSocket, String server) throws IOException {
        Object object = this.connectMonitor;
        synchronized (object) {
            if (this.connected) {
                throw new IllegalStateException("Connect requested, but we are already connected!");
            }
            this.connectUnsafe(customSocket, server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.eventMonitor;
        synchronized (object) {
            this.disconnectPending = true;
            this.eventMonitor.notifyAll();
            return;
        }
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public String toString() {
        return "IRCConnection";
    }

    public void addStateObserver(Observer observer) {
        Debug.println(this, "Added state observer " + observer, 20);
        this.stateObservers.addObserver(observer);
    }

    public void removeStateObserver(Observer observer) {
        Debug.println(this, "Removed state observer " + observer, 20);
        this.stateObservers.deleteObserver(observer);
    }

    public void addCommandObserver(Observer observer) {
        Debug.println(this, "Added command observer " + observer, 20);
        this.commandObservers.addObserver(observer);
    }

    public void removeCommandObserver(Observer observer) {
        Debug.println(this, "Removed command observer " + observer, 20);
        this.commandObservers.deleteObserver(observer);
    }

    public State getState() {
        return this.state;
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public void sendCommand(Command command) {
        this.sendCommand((OutCommand)command);
    }

    public void sendCommand(OutCommand command) {
        this.commandSender.sendCommand(command);
    }

    public CommandSender getCommandSender() {
        return this.commandSender;
    }

    public void setCommandSender(CommandSender sender) {
        this.commandSender = sender;
    }

    public String getLocalhost() {
        return "localhost";
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public String getRemotehost() {
        return this.clientState.getServer();
    }

    public void setSendDelay(int sleepTime) {
        this.sendDelay = sleepTime;
    }

    public CronManager getCronManager() {
        if (this.cronManager == null) {
            this.cronManager = new CronManager();
        }
        return this.cronManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectCommand(String fakeCommand) {
        Object object = this.eventMonitor;
        synchronized (object) {
            this.localEventQueue.add(fakeCommand);
            this.eventMonitor.notifyAll();
        }
    }

    void socketError(IOException ioe) {
        Debug.println(this, "Socket error called.", 20);
        Debug.println(this, ioe.toString(), 6);
        this.disconnect();
    }

    public static String[] parseRawString(String wholeString) {
        String prefix = "";
        String identifier = "";
        String params = "";
        StringTokenizer tokens = new StringTokenizer(wholeString, " ");
        if (wholeString.charAt(0) == ':') {
            prefix = tokens.nextToken();
            prefix = prefix.substring(1, prefix.length());
        }
        identifier = tokens.nextToken();
        if (tokens.hasMoreTokens()) {
            params = tokens.nextToken("");
        }
        String[] result = new String[]{prefix, identifier, params};
        return result;
    }

    protected InCommand getCommandObject(String prefix, String identifier, String params) {
        InCommand command;
        InCommand commandFactory = this.commandRegister.getCommand(identifier);
        if (commandFactory == null) {
            if (UnknownError.isError(identifier)) {
                command = new UnknownError(identifier);
                Debug.println(this, "Using " + command, 6);
            } else if (UnknownReply.isReply(identifier)) {
                command = new UnknownReply(identifier);
                Debug.println(this, "Using " + command, 6);
            } else {
                Debug.println(this, "Unknown command", 6);
                command = new UnknownCommand();
            }
        } else {
            command = commandFactory.parse(prefix, identifier, params);
            if (command == null) {
                Debug.println(this, "CommandFactory[" + commandFactory + "] returned NULL", 5);
                return null;
            }
            Debug.println(this, "Using " + command, 20);
        }
        return command;
    }

    void incomingCommand(String wholeString) {
        String[] cmdBits;
        Debug.println(this, "RCV = " + wholeString, 10);
        try {
            cmdBits = IRCConnection.parseRawString(wholeString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String prefix = cmdBits[0];
        String identifier = cmdBits[1];
        String params = cmdBits[2];
        InCommand command = this.getCommandObject(prefix, identifier, params);
        command.setSourceString(wholeString);
        this.localCommandUpdate(command);
    }

    private void localCommandUpdate(InCommand command) {
        State cmdState = command.getState();
        if (cmdState != State.UNKNOWN && cmdState != this.getState()) {
            this.setState(cmdState);
        }
        try {
            this.commandObservers.setChanged();
            this.commandObservers.notifyObservers(command);
        }
        catch (Throwable e) {
            Debug.println(this, "Command notify failed.", 5);
            Debug.println(this, e.toString(), 5);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectUnsafe(Socket socket, String server) throws IOException {
        this.socket = socket;
        this.socketWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
        this.socketReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        Object object = this.inputHandlerMonitor;
        synchronized (object) {
            if (this.inputHandler != null && this.inputHandler.pendingMessages()) {
                Debug.println(this, "Tried to connect, but there are pending messages!", 0);
                return;
            }
            if (this.inputHandler != null && this.inputHandler.isAlive()) {
                Debug.println(this, "Tried to connect, but the input handler is still alive!", 0);
                return;
            }
            this.clientState.setServer(server);
            this.clientState.setPort(socket.getPort());
            this.connected = true;
            this.inputHandler = new InputHandler(this.socketReader, this, this.eventMonitor);
            this.inputHandler.setDaemon(this.daemon);
            this.inputHandler.start();
        }
        this.setState(State.UNREGISTERED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processEvents() {
        boolean events = false;
        Object object = this.inputHandlerMonitor;
        synchronized (object) {
            String msg;
            while (this.inputHandler != null && this.inputHandler.pendingMessages()) {
                msg = this.inputHandler.getMessage();
                this.incomingCommand(msg);
                events = true;
            }
            while (this.localEventQueue != null && !this.localEventQueue.isEmpty()) {
                msg = (String)this.localEventQueue.removeFirst();
                this.incomingCommand(msg);
                events = true;
            }
            if (this.disconnectPending) {
                Debug.println(this, "Process events: Disconnect pending.", 20);
                this.doDisconnect();
                events = true;
            }
        }
        return events;
    }

    private boolean pendingEvents() {
        if (this.inputHandler != null && this.inputHandler.pendingMessages()) {
            return true;
        }
        if (this.disconnectPending) {
            return true;
        }
        return this.localEventQueue != null && !this.localEventQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doDisconnect() {
        Object object = this.connectMonitor;
        synchronized (object) {
            this.disconnectPending = false;
            if (!this.connected) {
                return;
            }
            this.connected = false;
            try {
                long startTime = System.currentTimeMillis();
                long sleepTime = 1000L;
                long stopTime = startTime + 1000L;
                Debug.println(this, "Sleeping for a bit (1000)..", 20);
                while (stopTime - System.currentTimeMillis() > 0L) {
                    this.connectMonitor.wait(stopTime - System.currentTimeMillis());
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            Debug.println(this, "Stopping input handler.", 20);
            Debug.println(this, "Closing socket.", 20);
            try {
                this.socket.close();
                this.connected = false;
            }
            catch (IOException ioe) {
                this.connected = false;
                return;
                catch (Throwable throwable) {
                    this.connected = false;
                    throw throwable;
                }
            }
        }
        object = this.inputHandlerMonitor;
        synchronized (object) {
            Debug.println(this, "Waiting for the input handler to die..", 20);
            try {
                if (this.inputHandler.isAlive()) {
                    this.inputHandler.join();
                } else {
                    Debug.println(this, "No waiting required, input hander is already dead.", 20);
                }
            }
            catch (InterruptedException ie) {
                Debug.println(this, "Error in join(): " + ie, 20);
            }
            Debug.println(this, "Done waiting for the input handler to die.", 20);
        }
        this.processEvents();
        this.setState(State.UNCONNECTED);
    }

    private void setState(State newState) {
        if (this.settingState) {
            this.stateQueue.addLast(newState);
            return;
        }
        this.settingState = true;
        if (this.state == newState) {
            return;
        }
        while (true) {
            this.state = newState;
            Debug.println(this, "State switch: " + this.state, 15);
            try {
                this.stateObservers.setChanged();
                this.stateObservers.notifyObservers(newState);
            }
            catch (Throwable e) {
                Debug.println(this, "State update failed.", 5);
                Debug.println(this, e.toString(), 5);
                e.printStackTrace();
            }
            if (this.stateQueue.isEmpty()) break;
            newState = (State)this.stateQueue.removeFirst();
        }
        this.settingState = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalSendCommand(String str) {
        try {
            Object object = this.eventMonitor;
            synchronized (object) {
                Debug.println(this, "SEND= " + str, 10);
                if (this.disconnectPending) {
                    Debug.println(this, "Send cancelled, disconnect pending.", 20);
                    return;
                }
                this.socketWriter.write(str + "\r\n");
                this.socketWriter.flush();
                try {
                    Thread.sleep(this.sendDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (IOException ioe) {
            this.socketError(ioe);
        }
    }

    private class DefaultCommandSender
    implements CommandSender {
        private DefaultCommandSender() {
        }

        public CommandSender getNextCommandSender() {
            return null;
        }

        public void sendCommand(OutCommand oc) {
            IRCConnection.this.finalSendCommand(oc.render());
        }
    }

    private class EventThread
    extends Thread {
        public EventThread() {
            super("EventThread");
        }

        public void run() {
            this.handleEvents();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleEvents() {
            try {
                while (true) {
                    Debug.println(this, "Processing events", 20);
                    while (IRCConnection.this.processEvents()) {
                    }
                    Object object = IRCConnection.this.eventMonitor;
                    synchronized (object) {
                        if (!IRCConnection.this.pendingEvents()) {
                            IRCConnection.this.eventMonitor.wait();
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public String toString() {
            return "EventThread";
        }
    }
}

