/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr;

import f00f.net.irc.martyr.Debug;
import f00f.net.irc.martyr.IRCConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;

class InputHandler
extends Thread {
    private BufferedReader reader;
    private IRCConnection connection;
    private LinkedList messages;
    private Object eventMonitor;
    private static int serialGen = 0;
    private int serialNumber = serialGen++;

    public InputHandler(BufferedReader reader, IRCConnection connection, Object eventMonitor) {
        super("InputHandler");
        this.reader = reader;
        this.connection = connection;
        this.messages = new LinkedList();
        this.eventMonitor = eventMonitor;
        Debug.println(this, "New", 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pendingMessages() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            return !this.messages.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            return (String)this.messages.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Debug.println(this, "Running", 20);
        try {
            while (true) {
                String str;
                if ((str = this.reader.readLine()) == null) {
                    this.connection.socketError(new IOException("Socket disconnected"));
                    return;
                }
                Object object = this.messages;
                synchronized (object) {
                    this.messages.addLast(str);
                }
                object = this.eventMonitor;
                synchronized (object) {
                    this.eventMonitor.notifyAll();
                }
                continue;
                break;
            }
        }
        catch (IOException ioe) {
            this.connection.socketError(ioe);
            return;
        }
        finally {
            Debug.println(this, "Input handler has DIED!", 20);
        }
    }

    public String toString() {
        return "InputHandler[" + this.serialNumber + "]";
    }
}

