/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.CommandRegister;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.State;
import f00f.net.irc.martyr.clientstate.ClientState;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class GenericInCommand
implements InCommand {
    protected Map attributes = new HashMap();
    private String sourceString;

    protected GenericInCommand() {
    }

    protected GenericInCommand(String[] attributeNames) {
        for (int i = 0; i < attributeNames.length; ++i) {
            this.attributes.put(attributeNames[i], null);
        }
    }

    public String getAttribute(String key) {
        return (String)this.attributes.get(key);
    }

    public Iterator getAttributeKeys() {
        return Collections.unmodifiableSet(this.attributes.keySet()).iterator();
    }

    protected void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public State getState() {
        return State.REGISTERED;
    }

    public void selfRegister(CommandRegister commandRegister) {
        commandRegister.addCommand(this.getIrcIdentifier(), this);
    }

    public abstract InCommand parse(String var1, String var2, String var3);

    public boolean updateClientState(ClientState state) {
        return false;
    }

    public String getParameter(String params, int num) {
        int colonIndex = params.indexOf(58);
        String textParam = null;
        String spaceParams = null;
        if (colonIndex < 0) {
            spaceParams = params;
        } else {
            if (colonIndex == 0) {
                if (num == 0) {
                    return params.substring(1, params.length());
                }
                return null;
            }
            spaceParams = params.substring(0, colonIndex).trim();
            textParam = params.substring(colonIndex + 1, params.length());
        }
        StringTokenizer tokens = new StringTokenizer(spaceParams, " ");
        while (tokens.hasMoreTokens() && num > 0) {
            --num;
            tokens.nextToken();
        }
        if (num == 0 && tokens.hasMoreTokens()) {
            return tokens.nextToken();
        }
        if (num == 0 && !tokens.hasMoreTokens()) {
            return textParam;
        }
        return null;
    }

    public int getIntParameter(String params, int paramnum, int defaultNum) {
        try {
            return Integer.parseInt(this.getParameter(params, paramnum));
        }
        catch (NumberFormatException nfe) {
            return defaultNum;
        }
    }

    public void setSourceString(String source) {
        this.sourceString = source;
    }

    public String getSourceString() {
        return this.sourceString;
    }
}

