/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.CommandRegister;
import f00f.net.irc.martyr.Debug;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.Mode;
import f00f.net.irc.martyr.OutCommand;
import f00f.net.irc.martyr.State;
import f00f.net.irc.martyr.clientstate.Channel;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.ChannelModeCommand;
import f00f.net.irc.martyr.commands.UserModeCommand;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ModeCommand
implements InCommand,
OutCommand {
    public static final String IDENTIFIER = "MODE";
    private String source;

    public Iterator getAttributeKeys() {
        return new LinkedList().iterator();
    }

    public String getAttribute(String key) {
        return null;
    }

    public static void registerMode(Map modes, Mode mode) {
        Character modeChar = new Character(mode.getChar());
        if (modes.get(modeChar) != null) {
            Debug.println("ModeCommand", "Warning: Two modes with same letter: " + modes.get(modeChar) + " and " + mode, 5);
        }
        modes.put(modeChar, mode);
    }

    public State getState() {
        return State.REGISTERED;
    }

    public void selfRegister(CommandRegister reg) {
        reg.addCommand(IDENTIFIER, this);
    }

    public String getIrcIdentifier() {
        return IDENTIFIER;
    }

    public InCommand parse(String prefix, String identifier, String params) {
        StringTokenizer tokens = new StringTokenizer(params);
        String str = tokens.nextToken();
        if (str == null) {
            return null;
        }
        if (Channel.isChannel(str)) {
            return new ChannelModeCommand(prefix, str, tokens);
        }
        return new UserModeCommand(prefix, str, tokens);
    }

    public String render() {
        throw new IllegalStateException("Don't try to send ModeCommand!");
    }

    public void setSourceString(String source) {
        this.source = source;
    }

    public String getSourceString() {
        return this.source;
    }

    public boolean updateClientState(ClientState cs) {
        return false;
    }

    public String toString() {
        return "ModeCommand";
    }

    public List parseModes(Map modes, StringTokenizer tokens) {
        LinkedList results = new LinkedList();
        while (tokens.hasMoreTokens()) {
            this.parseOneModeSet(modes, tokens, results);
        }
        return results;
    }

    private void parseOneModeSet(Map modes, StringTokenizer tokens, List results) {
        LinkedList<Mode> localModes = new LinkedList<Mode>();
        Mode.Sign sign = Mode.Sign.NOSIGN;
        String chars = tokens.nextToken();
        int stop = chars.length();
        for (int i = 0; i < stop; ++i) {
            char lookingAt = chars.charAt(i);
            if (lookingAt == '+') {
                sign = Mode.Sign.POSITIVE;
                continue;
            }
            if (lookingAt == '-') {
                sign = Mode.Sign.NEGATIVE;
                continue;
            }
            if (lookingAt == ':') continue;
            Mode mode = (Mode)modes.get(new Character(lookingAt));
            if (mode == null) {
                Debug.println(this, "Unknown mode: " + lookingAt, 6);
                continue;
            }
            mode = mode.newInstance();
            mode.setSign(sign);
            localModes.add(mode);
        }
        Iterator modesI = localModes.iterator();
        while (modesI.hasNext()) {
            Mode mode = (Mode)modesI.next();
            if (mode != null && mode.requiresParam() && tokens.hasMoreTokens()) {
                mode.setParam(tokens.nextToken());
            }
            results.add(mode);
        }
    }
}

