/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.clientstate.Channel;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.GenericCommand;
import f00f.net.irc.martyr.util.FullNick;

public class PartCommand
extends GenericCommand {
    private String reason;
    private String channel;
    private FullNick user;

    public PartCommand() {
        this(null, null, null);
    }

    public PartCommand(FullNick user, String channel, String reason) {
        this.user = user;
        this.reason = reason;
        this.channel = channel;
    }

    public PartCommand(String channel, String reason) {
        this(null, channel, reason);
    }

    public PartCommand(String channel) {
        this(null, channel, null);
    }

    public InCommand parse(String prefix, String identifier, String params) {
        return new PartCommand(new FullNick(prefix), this.getParameter(params, 0), this.getParameter(params, 1));
    }

    public String getIrcIdentifier() {
        return "PART";
    }

    public String renderParams() {
        if (this.reason != null) {
            return this.channel + " :" + this.reason;
        }
        return this.channel;
    }

    public String getReason() {
        return this.reason;
    }

    public String getChannel() {
        return this.channel;
    }

    public FullNick getUser() {
        return this.user;
    }

    public boolean updateClientState(ClientState state) {
        if (this.user.equals(state.getNick())) {
            state.removeChannel(this.channel);
            return true;
        }
        Channel chanObj = state.getChannel(this.channel);
        chanObj.removeMember(this.user, (InCommand)this);
        return true;
    }
}

