/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.CommandRegister;
import f00f.net.irc.martyr.Debug;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.GenericInCommand;
import f00f.net.irc.martyr.util.FullNick;
import f00f.net.irc.martyr.util.ParameterIterator;

public class WelcomeCommand
extends GenericInCommand {
    private String notice;
    private String nick;

    public WelcomeCommand() {
        this(null, null);
    }

    public WelcomeCommand(String nick, String notice) {
        this.notice = notice;
        this.nick = nick;
        Debug.println(this, "Nick is: `" + nick + "'", 15);
        Debug.println(this, "Notice is: `" + notice + "'", 15);
    }

    public InCommand parse(String prefix, String identifier, String params) {
        ParameterIterator pi = new ParameterIterator(params);
        String nick = pi.next().toString();
        String notice = null;
        if (pi.hasNext()) {
            notice = pi.next().toString();
        } else {
            notice = nick;
            nick = null;
        }
        if (pi.hasNext()) {
            Debug.println(this, "More than two parameters, confused.", 6);
        }
        return new WelcomeCommand(nick, notice);
    }

    public boolean updateClientState(ClientState state) {
        Debug.println(this, "updated client state with: " + new FullNick(this.nick), 20);
        state.setNick(new FullNick(this.nick));
        return true;
    }

    public String getIrcIdentifier() {
        return "001";
    }

    public void selfRegister(CommandRegister commandRegister) {
        commandRegister.addCommand("001", this);
        commandRegister.addCommand("002", this);
        commandRegister.addCommand("003", this);
        commandRegister.addCommand("004", this);
        commandRegister.addCommand("005", this);
    }

    public String getNotice() {
        return this.notice;
    }

    public String getNick() {
        return this.nick;
    }

    public String toString() {
        return "WelcomeCommand";
    }
}

