/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.dcc;

import f00f.net.irc.martyr.Debug;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class DccSendHandler
extends Thread {
    private Socket socket_;
    private String filename_;
    private int filesize_;
    private static int DEFAULT_BUF_SIZE = 5000;

    public DccSendHandler(Socket socket, String filename, int filesize) {
        this.socket_ = socket;
        this.filename_ = filename;
        this.filesize_ = filesize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDccSend(Socket socket, String filename, int filesize) throws IOException {
        OutputStream dest = this.getStreamForReceive(filename, filesize);
        InputStream incoming = socket.getInputStream();
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        byte[] buffer = new byte[DEFAULT_BUF_SIZE];
        int totalin = 0;
        try {
            int recvd;
            while ((recvd = incoming.read(buffer)) >= 0) {
                dest.write(buffer, 0, recvd);
                outgoing.writeInt(totalin += recvd);
            }
        }
        finally {
            dest.close();
        }
        Debug.println(this, "Done writing file: " + filename, 15);
        Debug.println(this, "Total bytes: " + totalin, 15);
        socket.close();
    }

    protected OutputStream getStreamForReceive(String filename, int filesize) throws IOException {
        throw new FileNotFoundException("Refusing to write '" + filename + "'");
    }

    public void run() {
        try {
            this.handleDccSend(this.socket_, this.filename_, this.filesize_);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

