/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.replies;

import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.clientstate.Channel;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.replies.GenericReply;
import java.util.Date;
import java.util.StringTokenizer;

public class TopicInfoReply
extends GenericReply {
    private String channelName;
    private Date date;
    private String author;

    public TopicInfoReply() {
    }

    public TopicInfoReply(String channelName, Date date, String author) {
        this.channelName = channelName;
        this.date = date;
        this.author = author;
    }

    public String getIrcIdentifier() {
        return "333";
    }

    public InCommand parse(String prefix, String identifier, String params) {
        Date date;
        StringTokenizer tokens = new StringTokenizer(params);
        tokens.nextToken();
        String chan = tokens.nextToken();
        String author = tokens.nextToken();
        try {
            date = new Date(Long.parseLong(tokens.nextToken()) * 1000L);
        }
        catch (NumberFormatException nfe) {
            date = new Date(0L);
        }
        return new TopicInfoReply(chan, date, author);
    }

    public boolean updateClientState(ClientState state) {
        Channel channel = state.getChannel(this.channelName);
        channel.setTopicDate(this.date);
        channel.setTopicAuthor(this.author);
        return true;
    }
}

