/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.services;

import f00f.net.irc.martyr.Debug;
import f00f.net.irc.martyr.GenericAutoService;
import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.State;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.QuitCommand;
import java.io.IOException;
import java.net.UnknownHostException;

public class AutoReconnect
extends GenericAutoService {
    private static final int DBG_LVL = 15;
    private int attempt;
    private int maxAttempts;
    private int sleepTime;
    private boolean disableOnQuit;
    public static final int DEFAULT_MAX_ATTEMPTS = 5;
    public static final int DEFAULT_CONNECT_SLEEPTIME = 1000;
    public static final boolean DEFAULT_DISABLE_ON_QUIT = true;

    public AutoReconnect(IRCConnection connection, int maxAttempts, int sleepBetween, boolean disableOnQuit) {
        super(connection);
        this.disableOnQuit = disableOnQuit;
        this.maxAttempts = maxAttempts;
        this.sleepTime = sleepBetween;
        this.attempt = 0;
        this.enable();
    }

    public AutoReconnect(IRCConnection connection, int maxAttempts, int sleepBetween) {
        this(connection, maxAttempts, sleepBetween, true);
    }

    public AutoReconnect(IRCConnection connection) {
        this(connection, 5, 1000);
    }

    public void go(String server, int port) {
        this.doConnectionLoop(server, port);
    }

    protected void connect() throws IOException {
        ClientState cstate = this.getConnection().getClientState();
        this.connect(cstate.getServer(), cstate.getPort());
    }

    protected void connect(String server, int port) throws UnknownHostException, IOException {
        this.getConnection().connect(server, port);
    }

    protected void updateState(State state) {
        Debug.println(this, "Update with state " + state, 20);
        if (state == State.UNCONNECTED) {
            this.doConnectionLoop();
        }
        Debug.println(this, "Returned from " + state, 20);
    }

    protected void doConnectionLoop() {
        this.doConnectionLoop(null, -1);
    }

    protected void doConnectionLoop(String server, int port) {
        boolean keeptrying = true;
        while (keeptrying && this.enabled) {
            Exception error = null;
            try {
                if (server == null) {
                    this.connect();
                } else {
                    this.connect(server, port);
                }
                keeptrying = false;
            }
            catch (Exception e) {
                error = e;
                keeptrying = true;
            }
            if (!keeptrying) continue;
            keeptrying = this.failedToConnect(error);
        }
    }

    protected void finalFailure() {
        Debug.println(this, "Final failure.", 15);
    }

    protected boolean failedToConnect(Exception error) {
        Debug.println(this, "Error connecting: " + error, 15);
        ++this.attempt;
        if (this.attempt >= this.maxAttempts) {
            Debug.println(this, "Tried " + this.attempt + " times, giving up.", 15);
            this.finalFailure();
            return false;
        }
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException ie) {
            return false;
        }
        return true;
    }

    protected void updateCommand(InCommand command) {
        if (this.disableOnQuit && command instanceof QuitCommand && ((QuitCommand)command).isOurQuit(this.getConnection().getClientState())) {
            Debug.println(this, "Disabling due to receiving own QUIT.", 15);
            this.disable();
        }
    }

    public String toString() {
        return "AutoReconnect [" + this.attempt + "]";
    }
}

