/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.test;

import f00f.net.irc.martyr.GenericCommandAutoService;
import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.commands.RawCommand;
import f00f.net.irc.martyr.services.AutoResponder;
import f00f.net.irc.martyr.test.TailTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;

public class IRCConsole
extends Frame {
    public static final long serialVersionUID = 1L;
    private transient IRCConnection connection = new IRCConnection();
    private TextArea outputArea;
    private TextField inputArea;

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Args: server port");
            System.exit(1);
        }
        String server = args[0];
        int port = Integer.parseInt(args[1]);
        IRCConsole frame = new IRCConsole();
        frame.setVisible(true);
        frame.setSize(600, 400);
        frame.connect(server, port);
    }

    public IRCConsole() {
        new AutoResponder(this.connection);
        this.outputArea = new TailTextArea("", 60, 5);
        this.inputArea = new TextField();
        new CommandListener(this.connection, this.outputArea);
        this.inputArea.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                IRCConsole.this.outputArea.append("SEND: " + IRCConsole.this.inputArea.getText() + "\n");
                IRCConsole.this.connection.sendCommand(new RawCommand(IRCConsole.this.inputArea.getText()));
                IRCConsole.this.inputArea.setText("");
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.outputArea, "Center");
        this.add((Component)this.inputArea, "South");
    }

    public void connect(String server, int port) throws IOException, UnknownHostException {
        this.connection.connect(server, port);
    }

    public static class CommandListener
    extends GenericCommandAutoService {
        private TextArea ta;

        public CommandListener(IRCConnection conn, TextArea texta) {
            super(conn);
            this.ta = texta;
            this.enable();
        }

        public void updateCommand(InCommand c) {
            this.ta.append("RECV: " + c.getSourceString() + "\n");
        }
    }
}

